#include <bits/stdc++.h>
#include <chrono>
using namespace std;

typedef long long ll;

struct Ponco {
  ll w;
  ll v;
  double ratio;
  int idx;

  bool operator<(const Ponco &rhs) const { return ratio < rhs.ratio; }
};

int main() {
  ios_base::sync_with_stdio(false);
  cin.tie(0);
  cout.tie(0);
  cerr.tie(0);

  int n, w;
  double epsilon;
  cin >> n >> w >> epsilon;

  vector<Ponco> poncoi;
  int big = 1 << min(n, 25);
  vector<ll> memow(2), memov(2);
  ll wi, vi;
  for (int i = 0; i < n; i++) {
    cin >> wi >> vi;
    poncoi.push_back(Ponco{wi, vi, (double)wi / (double)vi, i});
  }

  sort(poncoi.begin(), poncoi.end());

  ll best[3] = {0, 0, 0};
  memow[0] = 0;
  memow[1] = poncoi[0].w;
  memov[0] = 0;
  memov[1] = poncoi[0].v;

  auto preop = chrono::high_resolution_clock::now();
  for (int i = 2; i < big; i++) {
    int hmm = i - (1 << (31 - __builtin_clz(i)));
    memow.push_back(memow[hmm] + poncoi[31 - __builtin_clz(i)].w);
    memov.push_back(memov[hmm] + poncoi[31 - __builtin_clz(i)].v);
    if (memow[i] <= w && memov[i] >= best[1]) {
      best[0] = memow[i];
      best[1] = memov[i];
      best[2] = i;
    }

    if ((i & 0x3FFF) == 0) {
      auto now = chrono::high_resolution_clock::now();
      auto ms_int = chrono::duration_cast<chrono::milliseconds>(now - preop);
      // cout << ms_int.count() << '\n';
      if (ms_int.count() > 995) {
        // optimal! stopping distance
        break;
      }
    }
  }
  cout << __builtin_popcount(best[2]) << '\n';
  for (int i = 0; i < 32; i++) {
    if (best[2] & (1 << i)) {
      cout << poncoi[i].idx + 1 << ' ';
    }
  }
  cout << '\n';
  // cout << best[0] << ' ' << best[1] << ' ' << best[2] << ' ' << '\n';

  return 0;
}